//[BotStacks Chat SDK](../../index.md)/[ai.botstacks.sdk.state](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [AttachmentType](-attachment-type/index.md) | [common]<br>enum [AttachmentType](-attachment-type/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[AttachmentType](-attachment-type/index.md)&gt; <br>The type of a Message attachment. Currently limited to images and location. |
| [ChannelsPager](-channels-pager/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [ChannelsPager](-channels-pager/index.md)(val list: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;channels&quot;) : [Pager](-pager/index.md)&lt;[Chat](-chat/index.md)&gt; |
| [Chat](-chat/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>class [Chat](-chat/index.md)(id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val kind: [ChatType](-chat-type/index.md)) : [Pager](-pager/index.md)&lt;[Message](-message/index.md)&gt; , [Identifiable](-identifiable/index.md)<br>Class that holds information for a given Chat (Group, DM, etc.) |
| [ChatType](-chat-type/index.md) | [common]<br>enum [ChatType](-chat-type/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[ChatType](-chat-type/index.md)&gt; <br>The type of a Chat entity. |
| [ContactsPager](-contacts-pager/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [ContactsPager](-contacts-pager/index.md)(val list: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;contacts&quot;) : [Pager](-pager/index.md)&lt;[User](-user/index.md)&gt; |
| [FavoritesPager](-favorites-pager/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [FavoritesPager](-favorites-pager/index.md)(val list: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;favorites&quot;) : [Pager](-pager/index.md)&lt;[Message](-message/index.md)&gt; |
| [Identifiable](-identifiable/index.md) | [common]<br>interface [Identifiable](-identifiable/index.md) |
| [MemberRole](-member-role/index.md) | [common]<br>enum [MemberRole](-member-role/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[MemberRole](-member-role/index.md)&gt; <br>The role of a User Member of a Chat |
| [Message](-message/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [Message](-message/index.md)(val id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), createdAt: Instant, userID: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), parentID: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, chatID: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), attachments: [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[MessageAttachment](-message-attachment/index.md)&gt; = mutableStateListOf(), reactions: Reactions = mutableStateListOf()) : [Identifiable](-identifiable/index.md)<br>A representation of a Message in a given [Chat](-chat/index.md). |
| [MessageAttachment](-message-attachment/index.md) | [common]<br>data class [MessageAttachment](-message-attachment/index.md)(val id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val type: [AttachmentType](-attachment-type/index.md), val url: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), val data: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, val mime: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, val width: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)?, val height: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)?, val duration: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)?, val address: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)?, val latitude: [Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)?, val longitude: [Double](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-double/index.html)?)<br>An attachments that can be included with a Message. |
| [NotificationSetting](-notification-setting/index.md) | [common]<br>enum [NotificationSetting](-notification-setting/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[NotificationSetting](-notification-setting/index.md)&gt; <br>Notification setting for a user, can be set per chat |
| [OnlineStatus](-online-status/index.md) | [common]<br>enum [OnlineStatus](-online-status/index.md) : [Enum](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-enum/index.html)&lt;[OnlineStatus](-online-status/index.md)&gt; <br>A User's online status in this Chat silo |
| [Pager](-pager/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>abstract class [Pager](-pager/index.md)&lt;[T](-pager/index.md) : [Identifiable](-identifiable/index.md)&gt;(val id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = uuid(), val items: [SnapshotStateList](https://developer.android.com/reference/kotlin/androidx/compose/runtime/snapshots/SnapshotStateList.html)&lt;[T](-pager/index.md)&gt; = mutableStateListOf(), val pageSize: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html) = 20) |
| [Participant](-participant/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [Participant](-participant/index.md)(user_id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), chat_id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html), created_at: Instant, role: [MemberRole](-member-role/index.md))<br>A representation for a participant in a given [Chat](-chat/index.md). |
| [RepliesPager](-replies-pager/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [RepliesPager](-replies-pager/index.md)(val message: [Message](-message/index.md)) : [Pager](-pager/index.md)&lt;[Message](-message/index.md)&gt; |
| [User](-user/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [User](-user/index.md)(val id: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html)) : [Identifiable](-identifiable/index.md)<br>A representation for a User within BotStacks. |
| [UsersPager](-users-pager/index.md) | [common]<br>@[Stable](https://developer.android.com/reference/kotlin/androidx/compose/runtime/Stable.html)<br>data class [UsersPager](-users-pager/index.md)(val list: [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = &quot;users&quot;) : [Pager](-pager/index.md)&lt;[User](-user/index.md)&gt; |
